<?php

namespace App\Controllers\Admin;

use App\Controllers\BaseController;
use App\Models\EkstrakurikulerModel;

class Ekstrakurikuler extends BaseController
{
    protected $model;

    public function __construct()
    {
        $this->model = new EkstrakurikulerModel();
    }

    public function index()
    {
        return view('admin/ekstrakurikuler/index', [
            'title' => 'Ekstrakurikuler',
            'items' => $this->model
                ->orderBy('urutan', 'ASC')
                ->findAll(),
        ]);
    }

    public function create()
    {
        return view('admin/ekstrakurikuler/create', [
            'title'  => 'Tambah Ekstrakurikuler',
            'errors' => session()->getFlashdata('errors'),
        ]);
    }

    // ================= STORE =================
    public function store()
    {
        $rules = [
            'nama'           => 'required',
            'urutan'         => 'required|integer',
            'foto'           => 'uploaded[foto]|is_image[foto]|max_size[foto,2048]',
            'deskripsi'      => 'permit_empty',
            'pembina'        => 'permit_empty',
            'jumlah_anggota' => 'permit_empty',
        ];

        if (! $this->validate($rules)) {
            return redirect()->back()
                ->withInput()
                ->with('errors', $this->validator->getErrors());
        }

        // ===== UPLOAD FOTO =====
        $foto = $this->request->getFile('foto');
        $namaFoto = $foto->getRandomName();
        $foto->move('uploads/ekstrakurikuler', $namaFoto);

        // ===== SIMPAN KE DB =====
        $this->model->insert([
            'nama'           => $this->request->getPost('nama'),
            'deskripsi'      => $this->request->getPost('deskripsi'),
            'pembina'        => $this->request->getPost('pembina'),
            'jumlah_anggota' => $this->request->getPost('jumlah_anggota'),
            'urutan'         => $this->request->getPost('urutan'),
            'foto'           => $namaFoto,
        ]);

        return redirect()->to(base_url('admin/ekstrakurikuler'))
            ->with('msg', 'Ekstrakurikuler berhasil ditambahkan');
    }

    public function delete($id)
    {
        $item = $this->model->find($id);

        if ($item && !empty($item['foto'])) {
            $path = FCPATH . 'uploads/ekstrakurikuler/' . $item['foto'];
            if (is_file($path)) {
                unlink($path);
            }
        }

        $this->model->delete($id);

        return redirect()->back()
            ->with('msg', 'Data berhasil dihapus');
    }
    public function edit($id)
{
    $item = $this->model->find($id);

    if (! $item) {
        return redirect()->to(base_url('admin/ekstrakurikuler'))
            ->with('error', 'Data tidak ditemukan');
    }

    return view('admin/ekstrakurikuler/create', [
        'title' => 'Edit Ekstrakurikuler',
        'item'  => $item,
        'errors'=> session()->getFlashdata('errors'),
    ]);
}
public function update($id)
{
    $rules = [
        'nama'            => 'required',
        'deskripsi'       => 'permit_empty',
        'pembina'         => 'permit_empty',
        'jumlah_anggota'  => 'permit_empty',
        'urutan'          => 'permit_empty|integer',
    ];

    if (! $this->validate($rules)) {
        return redirect()->back()
            ->withInput()
            ->with('errors', $this->validator->getErrors());
    }

    $this->model->update($id, [
        'nama'           => $this->request->getPost('nama'),
        'deskripsi'      => $this->request->getPost('deskripsi'),
        'pembina'        => $this->request->getPost('pembina'),
        'jumlah_anggota' => $this->request->getPost('jumlah_anggota'),
        'urutan'         => $this->request->getPost('urutan'),
    ]);

    return redirect()->to(base_url('admin/ekstrakurikuler'))
        ->with('success', 'Data berhasil diupdate');
}
}
